---
obsidianUIMode: preview
---

This section helps you build and improvise dynamic combat encounters based on the fiction of the game.

## Start with the Story

Good combat encounters begin with the story. Instead of building combat encounters as fixed components of the game, let combat encounters evolve naturally from the story taking place at the table.

Begin by asking the following question: What monsters make sense given the current location and situation? Then let that question guide you in the creation of a list of monsters and NPCs that might show up at a given location, and in what quantity.

Instead of predefining scenes as combat, roleplaying, or exploration, let the characters' approach determine what happens. Maybe they fight the guards at the gatehouse. Maybe they sneak past. Maybe they try to play the part of hired mercenaries. But let whatever happens come from the choices of the players.

## Average Character Hit Points

Gauging the level of challenge in an encounter often comes down to comparing the amount of damage a monster can deal to the hit points of the characters. Hit points vary widely between classes, but you can use the following formula to estimate an average character's hit points at a given level: (Level × 7) + 3.

By giving you a rough estimation of how tough characters of a given level are, this formula can help you gauge how dangerous a specific monster will be, as well as judging the potential deadliness of traps, hazards, and other effects that deal damage.

## Potential Deadliness

Assuming that your chosen monsters aren't dealing damage that easily overwhelms the characters' hit points, you can usually not worry about an encounter's difficulty — unless the encounter is potentially deadly. You can gauge an encounter's potential deadliness with the following benchmark:

**An encounter might be deadly if the total of all the monsters' challenge ratings is greater than one quarter of the total of all the characters' levels, or one half of their levels if the characters are 5th level or higher.**

To use this benchmark for characters of 1st through 4th level, add up the challenge ratings of all monsters in the encounter. Then add up the levels of all of the characters and divide that number by 4. If the challenge level summation is greater than the sum of character levels divided by 4, the encounter might be deadly. If the characters are above 5th level, use the same process but divide the total character levels by 2 instead of 4.

Each time the characters gain a new level, calculate this deadly benchmark score and jot it down in your preparation notes so you have it on hand. If you find that the characters in your game often have an easy time with potentially deadly encounters, treat the characters as though they are one or more levels higher. This will raise the benchmark at which an encounter might become deadly, making the calculation more accurate.

This baseline assumes multiple monsters. A single monster may be deadly if it's challenge rating is equal to the average level of the characters or 1.5× the average level of the characters if they're above 5th level.

## Character Capabilities Vary

No chart, table, or equation works perfectly to judge encounter balance at any given level, because no such system can take into account the wide range of options that can affect combat. Any individual character's effective power in a fight can go well beyond what's expected for their given level, especially at higher levels. And other factors that can affect a character's power might include any of the following:

* Player experience
* Class synergy between different characters in the party
* Magic items
* Environmental and situational circumstances
* Feats and multiclassing
* The total number of actions on either side
* How well rested the characters are

So use the benchmarks for determining whether an encounter might be deadly as a starting point. Then trust that you'll be better able to gauge what your characters can handle in combat the more you see them in action during the game.

## Scaling for Higher Levels

As characters reach 11th level and higher, the deadly encounter benchmark becomes less useful for accurately representing a deadly encounter. Depending on the capabilities of those higher-level characters, monsters might pose even less of a threat than their challenge rating denotes. As such, you can further adjust the deadly encounter benchmark to account for this power with the following optional guideline:

At 11th level and higher, an encounter might be deadly if the total of all the monsters' challenge ratings is greater than three quarters of the total of all the characters' levels, or if it is equal to the total of their levels if the characters are 17th level or higher.

This sets up encounters of a much greater challenge than the baseline benchmark, but it might work more accurately for higher-powered characters.

The following table summarizes the Lazy Encounter Benchmark for three, four, five, or six 1st to 20th level characters. It includes the total monster CR for a potentially deadly encounter and the maximum CR for any single creature in a battle. At 11th level and above, it includes the lower and higher benchmarks described above.

| Lazy Encounter Benchmark for Potentially Deadly Encounters |       |       |        |        |                       |
| ---------------------------------------------------------- | ----- | ----- | ------ | ------ | --------------------- |
| Char Lvl / Num Chars                                       | 3     | 4     | 5      | 6      | Max Single Monster CR |
| 1                                                          | 1     | 1     | 1      | 2      | 0.5                   |
| 2                                                          | 2     | 2     | 3      | 3      | 2                     |
| 3                                                          | 2     | 3     | 4      | 5      | 3                     |
| 4                                                          | 3     | 4     | 5      | 6      | 4                     |
| 5                                                          | 8     | 10    | 13     | 15     | 8                     |
| 6                                                          | 9     | 12    | 15     | 18     | 9                     |
| 7                                                          | 11    | 14    | 18     | 21     | 11                    |
| 8                                                          | 12    | 16    | 20     | 24     | 12                    |
| 9                                                          | 14    | 18    | 23     | 27     | 14                    |
| 10                                                         | 15    | 20    | 25     | 30     | 15                    |
| 11                                                         | 17-25 | 22-33 | 28-41  | 33-50  | 17                    |
| 12                                                         | 18-27 | 24-36 | 30-45  | 36-54  | 18                    |
| 13                                                         | 20-29 | 26-39 | 33-49  | 39-59  | 20                    |
| 14                                                         | 21-32 | 28-42 | 35-53  | 42-63  | 21                    |
| 15                                                         | 23-34 | 30-45 | 38-56  | 45-68  | 23                    |
| 16                                                         | 24-36 | 32-48 | 40-60  | 48-72  | 24                    |
| 17                                                         | 26-51 | 34-68 | 43-85  | 51-102 | 26                    |
| 18                                                         | 27-54 | 36-72 | 45-90  | 54-108 | 27                    |
| 19                                                         | 29-57 | 38-76 | 48-95  | 57-114 | 29                    |
| 20                                                         | 30-60 | 40-80 | 50-100 | 60-120 | 30                    |
